﻿<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kadry.Forms" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">
    
    Date data;
    protected void dc_ContextLoad(object sender, EventArgs e) {
        data = ((ActualDate)dc[typeof(ActualDate)]).Actual;
		
		KadryPracownicyViewInfo.PrParams parsPracownicy;
        dc.Context.Get(out parsPracownicy);
		if (parsPracownicy != null)
		{
			ReportHeader["WYDZIAL"] = parsPracownicy.Wydział.GetLocalizedNazwa();
			ReportHeader["POSR"] = parsPracownicy.Pośrednio ? "Tak" : "Nie";
			ReportHeader["OKRES"] = parsPracownicy.Okres.ToString();
			ReportHeader["AKT"] = parsPracownicy.Aktualny.ToString();
		}
		else
		{
			StdParams parsWszyscy = null;
			dc.Context.Get(out parsWszyscy);
			ReportHeader["WYDZIAL"] = "";
			ReportHeader["POSR"] = "";
			ReportHeader["OKRES"] = parsWszyscy.Okres.ToString();
			ReportHeader["AKT"] = parsWszyscy.Aktualny.ToString();			
		}				
    }

    protected void Grid_BeforeRow(object sender, RowEventArgs args) {
        PracHistoria ph = (PracHistoria)args.Row;
        if (ph.Etat == null || ph.Etat.Okres == FromTo.Empty || !ph.Etat.Okres.Contains(data) ||
            ((ph.PrawoEmRent.Kod == KodPrawaEmRent.Brak || !ph.PrawoEmRent.OkresExt.Contains(data)) &&
            (ph.StopienNiepelnosp.Kod == KodStNiepelnosprawnosci.Brak || !ph.StopienNiepelnosp.OkresExt.Contains(data)))) {
            args.VisibleRow = false;
            return;
        }
    }
        

</script>

<HTML>
	<HEAD>
		<TITLE>Konta bankowe pracowników</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad"></ea:DataContext>			
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" runat="server"
				title="Lista osób z nabytym prawem do renty/emerytury|&lt;/strong&gt;Wydział:&lt;strong&gt; %WYDZIAL%|&lt;/strong&gt;Pośrednio:&lt;strong&gt; %POSR%|&lt;/strong&gt;Okres:&lt;strong&gt; %OKRES%|&lt;/strong&gt;Aktualny:&lt;strong&gt; %AKT%">
				</eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" 
                RowTypeName="Soneta.Kadry.PracHistoria,Soneta.KadryPlace" 
                onbeforerow="Grid_BeforeRow" LinkedRows="History">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Pracownik" 
                        Caption="Pracownik"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" 
                        DataMember="Etat.Wydzial.Kod" Caption="Wydział" 
                        Width="20"></ea:GridColumn>
					<ea:GridColumn runat="server" Caption="Kod tytułu ubezpieczenia" Width="10" 
                        DataMember="Etat.Ubezpieczenia.Tyub4.Kod" Format="{0:0000}" Align="Center" 
                        HideZero="True">
                    </ea:GridColumn>
				    <ea:GridColumn runat="server" Caption="Prawo do emerytury lub renty~kod" 
                        Width="10" DataMember="PrawoEmRent.Kod" Align="Center" Format="{0:d}" 
                        HideZero="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Caption="Prawo do emerytury lub renty~data uzysknia" 
                        Width="10" DataMember="PrawoEmRent.OkresExt.From" Align="Center" 
                        HideZero="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Align="Center" 
                        Caption="Prawo do emerytury lub renty~termin" 
                        DataMember="PrawoEmRent.OkresExt.To" HideZero="True" Width="10">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Caption="Stopień niepełnosprawności~kod" 
                        Width="10" DataMember="StopienNiepelnosp.Stopien" Align="Center" 
                        Format="{0:d}" HideZero="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" 
                        Caption="Stopień niepełnosprawności~data uzyskania" Width="10" 
                        DataMember="StopienNiepelnosp.OkresExt.From" Align="Center" 
                        HideZero="True">
                    </ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

